/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.sax;

import com.aptana.core.util.SourcePrinter;
import com.aptana.sax.ISchemaElement;
import com.aptana.sax.InvalidTransitionException;
import com.aptana.sax.Messages;
import com.aptana.sax.SchemaElement;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class Schema {
    private Map<String, ISchemaElement> _elementsByName = new HashMap<String, ISchemaElement>();
    private SchemaElement _rootElement;
    private Stack<ISchemaElement> _elementStack = new Stack();
    private ISchemaElement _currentElement;
    private boolean _allowFreeformMarkup;

    public boolean allowFreeformMarkup() {
        return this._allowFreeformMarkup;
    }

    public SchemaElement getRootElement() {
        return this._rootElement;
    }

    public boolean hasElement(String name) {
        return this._elementsByName.containsKey(name);
    }

    public void setAllowFreeformMarkup(boolean value) {
        this._allowFreeformMarkup = value;
    }

    public void setRootElement(String name) {
        ISchemaElement target = this.hasElement(name) ? this._elementsByName.get(name) : this.createElement(name);
        this._rootElement.addTransition(target);
    }

    public Schema() {
        this._rootElement = new SchemaElement(this, "#document");
    }

    public ISchemaElement createElement(String name) {
        return this.createElement(name, true);
    }

    public ISchemaElement createElement(String name, boolean unique) {
        ISchemaElement result = null;
        if (unique) {
            if (this.hasElement(name)) {
                result = this._elementsByName.get(name);
            } else {
                result = new SchemaElement(this, name);
                this._elementsByName.put(name, result);
            }
        } else {
            result = new SchemaElement(this, name);
        }
        return result;
    }

    public void moveTo(String namespaceURI, String localName, String qualifiedName, Attributes attributes) throws InvalidTransitionException, IllegalArgumentException, IllegalAccessException, InvocationTargetException, SAXException {
        if (!this._currentElement.isValidTransition(localName)) {
            Object[] messageArgs = new Object[]{localName, this._currentElement.getName()};
            String message = MessageFormat.format(Messages.Schema_Invalid_Child, messageArgs);
            SourcePrinter writer = new SourcePrinter();
            writer.println();
            writer.println(message);
            this.buildErrorMessage(writer, localName, attributes);
            throw new InvalidTransitionException(writer.toString());
        }
        this._elementStack.push(this._currentElement);
        this._currentElement = this._currentElement.moveTo(localName);
        this._currentElement.validateAttributes(attributes);
    }

    public void buildErrorMessage(SourcePrinter writer, String localName, Attributes attributes) {
        ISchemaElement element;
        writer.println().println(Messages.Schema_Element_Stack_Trace);
        int i = 0;
        while (i < Messages.Schema_Element_Stack_Trace.length()) {
            writer.print('=');
            ++i;
        }
        writer.println();
        i = 1;
        while (i < this._elementStack.size()) {
            element = (ISchemaElement)this._elementStack.get(i);
            writer.printlnWithIndent(element.toString()).increaseIndent();
            ++i;
        }
        if (!localName.equals(this._currentElement.getName())) {
            writer.printlnWithIndent(this._currentElement.toString()).increaseIndent();
        }
        writer.printWithIndent("<").print(localName);
        i = 0;
        while (i < attributes.getLength()) {
            writer.print(' ').print(attributes.getLocalName(i)).print("=\"").print(attributes.getValue(i)).print('\"');
            ++i;
        }
        writer.println("/>");
        if (!localName.equals(this._currentElement.getName())) {
            writer.decreaseIndent().printWithIndent("</").print(this._currentElement.getName()).println('>');
        }
        i = this._elementStack.size() - 1;
        while (i > 0) {
            element = (ISchemaElement)this._elementStack.get(i);
            writer.decreaseIndent().printWithIndent("</").print(element.getName()).println('>');
            --i;
        }
    }

    public void exitElement(String namespaceURI, String localName, String qualifiedName) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException, SAXException {
        this._currentElement = this._elementStack.pop();
    }

    public void reset() {
        if (this._rootElement == null) {
            throw new IllegalStateException(Messages.Schema_Missing_Root_Element);
        }
        this._elementStack.clear();
        this._currentElement = this._rootElement;
    }
}

